## Sid Meier's Civilization 4
## Copyright Firaxis Games 2005
## 
## This class is passed an argsList from CvAppInterface.onEvent
## The argsList can contain anything from mouse location to key info
## The EVENTLIST that are being notified can be found 


from CvPythonExtensions import *
import CvUtil
import CvScreensInterface
import CvDebugTools
import CvWBPopups
import PyHelpers
import Popup as PyPopup
import CvCameraControls
import CvTopCivs
import CvEventManager
import sys
import Terraform
	
gc = CyGlobalContext()
localText = CyTranslator()
PyPlayer = PyHelpers.PyPlayer
PyInfo = PyHelpers.PyInfo

tf = Terraform.Terraform()

# globals
###################################################
class CvCustomEventManager(CvEventManager.CvEventManager):
	def __init__(self):
		# initialize base class
		self.parent = CvEventManager.CvEventManager
		self.parent.__init__(self)
		self.Events[7502] = ('RemoveWaterPopup', self.__eventRemoveWaterApply , self.__eventRemoveWaterBegin)

	def onImprovementBuilt(self, argsList):
		self.parent.onImprovementBuilt(self, argsList);
		tf.onImprovementBuilt(argsList)

	def onRouteBuilt(self, argsList):
		self.parent.onRouteBuilt(self, argsList);
		tf.onRouteBuilt(argsList)

	def __eventRemoveWaterApply(self, playerID, userData, popupReturn):
		tf.eventRemoveWaterApply(playerID, userData, popupReturn)
		
	def __eventRemoveWaterBegin(self, argsList):
		tf.eventRemoveWaterBegin(argsList)